from agents import analyze_stock, risk_assessment, compare_stocks
from resolve_ticker import resolve_tickers, detect_intent
import google.generativeai as genai

def agent_router(query):
    """
    Routes the user query to the appropriate function or LLM.
    Ensures responses are concise and focused.
    """
    intent = detect_intent(query)
    tickers = resolve_tickers(query)

    # Handle missing tickers
    if not tickers:
        return "⚠️ Couldn’t find any valid stock symbol. Please check your input."

    # Route based on intent
    if intent == "analyze":
        raw_result = analyze_stock(tickers[0])
        return raw_result
    elif intent == "risk":
        raw_result = risk_assessment(tickers[0])
        return raw_result
    elif intent == "compare" and len(tickers) >= 2:
        raw_result = compare_stocks(tickers[0], tickers[1])
        return raw_result
    else:
        prompt = f"""
        Respond concisely to the user's query in 2-3 sentences, only providing the essential info. 
        Query: {query}
        """
        model = genai.GenerativeModel("gemini-2.5-flash")
        response = model.generate_content(prompt)
        return response.text
    