import google.generativeai as genai

def resolve_tickers(query):
    """
    Uses Gemini LLM to find stock ticker symbols mentioned in natural text.
    Example: "compare Tesla and Apple" → ["TSLA", "AAPL"]
    """
    model = genai.GenerativeModel("gemini-2.5-flash")
    prompt = f"""
    Extract the official Yahoo Finance ticker symbols for the companies mentioned in this text:
    "{query}"
    Respond with only a comma-separated list of ticker symbols (like TSLA,AAPL,NVDA).
    """
    response = model.generate_content(prompt)
    tickers = [t.strip().upper() for t in response.text.split(",") if t.strip()]
    return tickers

import google.generativeai as genai

def detect_intent(query):
    """
    Uses Gemini LLM to understand user intent and return one of:
    'analyze', 'risk', 'compare', or 'general'
    """
    model = genai.GenerativeModel("gemini-2.5-flash")
    prompt = f"""
    You are a routing assistant in a financial analysis system.
    Analyze the following user query and classify it into one of four categories:
    - 'analyze' → if user wants to check stock performance, trend, or price movement
    - 'risk' → if user asks about volatility, safety, or risk level
    - 'compare' → if user compares two or more companies
    - 'general' → if it’s general finance or unrelated

    Query: "{query}"

    Respond with only one word: analyze, risk, compare, or general.
    """
    response = model.generate_content(prompt)
    return response.text.strip().lower()
