# 💹 Agentic AI Stock Market Consultant

An AI-powered system that performs stock market trend, risk, and comparison analysis using **Gemini API** and **Agentic AI** principles.

## 🧠 Overview
This project demonstrates an intelligent, multi-agent stock consultant system that autonomously analyzes and compares stocks using financial data from Yahoo Finance and reasoning from Google Gemini LLM.

## ⚙️ Features
- 💬 Conversational chat interface using Streamlit  
- 📈 Trend analysis for stock prices  
- ⚠️ Risk assessment based on volatility  
- 🧮 Stock performance comparison  
- 🧠 LLM-driven decision-making (Gemini API)

## 🧩 System Architecture
User Query → Router Agent  → Gemini Response → Specialized Stock Agents → Gemini Response → Streamlit Chat UI

## 🧠 Agentic AI Design
- Router Agent → decides which analysis tool to use  
- Analysis Agent → analyzes price trends  
- Risk Agent → calculates volatility  
- Comparison Agent → compares two stocks  

## 🧰 Tech Stack
- Python 3.10+
- Streamlit
- yFinance
- Google Gemini API
- dotenv

## 🚀 Setup
1. Clone the repo  
2. Create a `.env` file with your API key  
3. Install dependencies:  
   ```bash
   pip install -r requirements.txt
4.streamlit run app.py


---

### **📁 Folder Structure**

Show your project organization.

```markdown
## 📁 Folder Structure
project/
├── app.py                 # Main Streamlit app
├── router.py              # Routes queries to the appropriate agent
├── agents.py              # Stock analysis, risk, and comparison functions
├── resolve_ticker.py      # LLM-based ticker symbol extraction
├── .env                   # Environment variables (API keys)
├── requirements.txt       # Python dependencies
└── README.md              # Project documentation


## 🧮 Example Queries
| User Query | Action Taken |
|-------------|--------------|
| "Analyze AAPL" | Trend analysis |
| "Risk TSLA" | Risk agent |
| "Compare NVDA and AMD" | Comparison agent |

## 📈 Future Enhancements
- Add sentiment analysis using financial news  
- Implement portfolio optimization  
- Add voice-based Gemini interaction

## 🏆 Conclusion
This project demonstrates an Agentic AI system that autonomously decides, reasons, and executes stock market analysis using Gemini API and custom agents.

## 👨‍💻 Author 
Name: Allen Bose
Year: 2025





